package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.model.P06B40T00Datatype;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (05/07/2010)
 */
public class P06B40T00DAO {
	
	static private P06B40T00DAO instance = null;

	public static P06B40T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B40T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B40T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B40T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B40T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B40T00DAO-select");
		P06B40T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B40T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B40_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B40_NUMEXP));
				result.setValorAnadComis(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_COMIS)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_COMIS));
				result.setValorAnadSubv(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_SUBV)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_SUBV));
				result.setValorAnadOtrosIng(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_OTROSING)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_OTROSING));
				result.setValorAnadCompras(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_COMPRAS)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_COMPRAS));
				result.setValorAnadServExt(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_SERVEXT)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_SERVEXT));
				result.setValorAnadOtrosTrib(lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_OTROSTRIB)==null?"":lrst.getString(P06BTablas.P06B_P06B40_VALORANAD_OTROSTRIB));
				result.setInverBruta(lrst.getString(P06BTablas.P06B_P06B40_INVERBRUTA)==null?"":lrst.getString(P06BTablas.P06B_P06B40_INVERBRUTA));
				result.setIngrComisEnt(lrst.getString(P06BTablas.P06B_P06B40_INGR_COMISENT)==null?"":lrst.getString(P06BTablas.P06B_P06B40_INGR_COMISENT));		
				result.setIngrComisOtros(lrst.getString(P06BTablas.P06B_P06B40_INGR_COMISOTROS)==null?"":lrst.getString(P06BTablas.P06B_P06B40_INGR_COMISOTROS));
				result.setIngrHonorProf(lrst.getString(P06BTablas.P06B_P06B40_INGR_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B40_INGR_HONORPROF));
				result.setIngrFinanc(lrst.getString(P06BTablas.P06B_P06B40_INGR_FINANC)==null?"":lrst.getString(P06BTablas.P06B_P06B40_INGR_FINANC));
				result.setGastCostesPer(lrst.getString(P06BTablas.P06B_P06B40_GAST_COSTESPER)==null?"":lrst.getString(P06BTablas.P06B_P06B40_GAST_COSTESPER));
				result.setGastComisAuxExt(lrst.getString(P06BTablas.P06B_P06B40_GAST_COMISAUXEXT)==null?"":lrst.getString(P06BTablas.P06B_P06B40_GAST_COMISAUXEXT));
				result.setGastComisOtros(lrst.getString(P06BTablas.P06B_P06B40_GAST_COMISOTROS)==null?"":lrst.getString(P06BTablas.P06B_P06B40_GAST_COMISOTROS));
				result.setGastFormacion(lrst.getString(P06BTablas.P06B_P06B40_GAST_FORMACION)==null?"":lrst.getString(P06BTablas.P06B_P06B40_GAST_FORMACION));
				result.setGastOtros(lrst.getString(P06BTablas.P06B_P06B40_GAST_OTROS)==null?"":lrst.getString(P06BTablas.P06B_P06B40_GAST_OTROS));
				result.setCtaActIngr(lrst.getString(P06BTablas.P06B_P06B40_CTAACT_INGR)==null?"":lrst.getString(P06BTablas.P06B_P06B40_CTAACT_INGR));
				result.setCtaActGast(lrst.getString(P06BTablas.P06B_P06B40_CTAACT_GAST)==null?"":lrst.getString(P06BTablas.P06B_P06B40_CTAACT_GAST));
				result.setCtaOtrasIngr(lrst.getString(P06BTablas.P06B_P06B40_CTAOTRAS_INGR)==null?"":lrst.getString(P06BTablas.P06B_P06B40_CTAOTRAS_INGR));
				result.setCtaOtrasGast(lrst.getString(P06BTablas.P06B_P06B40_CTAOTRAS_GAST)==null?"":lrst.getString(P06BTablas.P06B_P06B40_CTAOTRAS_GAST));
	        }
	        P06BLog.send(2,this, "Fin P06B40T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}

	
	private static String SELECT_BY_PK =
		"SELECT " +	
		P06BTablas.P06B_P06B40_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B40_NUMEXP + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_COMIS + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_SUBV + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_OTROSING + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_COMPRAS + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_SERVEXT + ", " + 
		P06BTablas.P06B_P06B40_VALORANAD_OTROSTRIB + ", " + 
		P06BTablas.P06B_P06B40_INVERBRUTA + ", " + 
		P06BTablas.P06B_P06B40_INGR_COMISENT + ", " + 
		P06BTablas.P06B_P06B40_INGR_COMISOTROS + ", " + 
		P06BTablas.P06B_P06B40_INGR_HONORPROF + ", " + 
		P06BTablas.P06B_P06B40_INGR_FINANC + ", " + 
		P06BTablas.P06B_P06B40_GAST_COSTESPER + ", " + 
		P06BTablas.P06B_P06B40_GAST_COMISAUXEXT + ", " + 
		P06BTablas.P06B_P06B40_GAST_COMISOTROS + ", " + 
		P06BTablas.P06B_P06B40_GAST_FORMACION + ", " + 
		P06BTablas.P06B_P06B40_GAST_OTROS + ", " + 
		P06BTablas.P06B_P06B40_CTAACT_INGR + ", " + 
		P06BTablas.P06B_P06B40_CTAACT_GAST + ", " + 
		P06BTablas.P06B_P06B40_CTAOTRAS_INGR + ", " + 
		P06BTablas.P06B_P06B40_CTAOTRAS_GAST +
		" FROM "+ P06BTablas.P06B_P06B40T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B40_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B40_NUMEXP + " = ?";

}
